package com.rocogz.merchant.entity.channel.product;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 扣款主体参数实体类
 * @date：2021/11/23
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("merchant_deduct_subject_params")
public class MerchantDeductSubjectParams extends IdEntity {

    private static final long serialVersionUID = 693366182413188679L;

    /**
    * 扣款主体编号
    */
    private String subjectCode;
    
    /**
    * 参数名称(字典值、可选)
    */
    private String paramName;
    
    /**
    * 参数值
    */
    private String paramValue;
    
    /**
    * 参数描述
    */
    private String description;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private Integer createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private Integer updateUser;
}