package com.rocogz.merchant.entity.customer.workflow;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 额度申请 审批流节点配置的审批人信息
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("merchant_customer_goods_config_node_approver")
public class MerchantCustomerGoodsConfigNodeApprover extends IdEntity {

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 节点业务类型：审核或审批、复核
     */
    private CustomerGoodsConfigNodeTypeEnum nodeType;

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 审批人所属主体编号
     */
    private String approverUserIssuingBodyCode;

    /**
     * 审批人所属主体名称
     */
    private String approverUserIssuingBodyName;

    /**
     * 审批人员工号
     */
    @TableField(exist = false)
    private String approverEmployeeNo;

    /**
     * 审批人所在部门
     */
    @TableField(exist = false)
    private String approverDepartment;

    /**
     * 审批人岗位
     */
    @TableField(exist = false)
    private String approverJob;

}
