package com.rocogz.merchant.entity.customer.workflow.apply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.customer.goods.workflow.apply.GoodsInstoreApplyApproveParamDto;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 产品入库申请审批记录表</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 16:30</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("merchant_customer_goods_instore_apply_approve_record")
public class GoodsInstoreApplyApproveRecord extends IdEntity {
    /**
     * 申请单编码
     */
    private String applyCode;

    /**
     * 审批结果, 通过或不通过
     *
     * @see Constant.GoodsInstoreApplyApproveResult
     */
    private String result;

    /**
     * 审批的节点编号
     */
    private String approveNodeCode;

    /**
     * 审批类型: 审核 或 审批 或 复核
     */
    private CustomerGoodsConfigNodeTypeEnum approveNodeType;

    /**
     * 审批节点名称
     */
    private String approveNodeName;

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 批注
     */
    private String remark;

    /**
     * 审批时间，也就是创建时间
     */
    private LocalDateTime approveTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 审批附件
     */
    @TableField(exist = false)
    private List<GoodsInstoreApplyAttach> attachList;

    /**
     * 通过审批请求的参数构建审批记录
     *
     * @param approveParam 审批请求参数
     * @return
     */
    public static GoodsInstoreApplyApproveRecord fromGoodsInstoreApplyApproveParamDto(GoodsInstoreApplyApproveParamDto approveParam) {
        if (approveParam == null){
            return null;
        }
        GoodsInstoreApplyApproveRecord approveRecord = new GoodsInstoreApplyApproveRecord();
        approveRecord.setApplyCode(approveParam.getApplyCode());
        approveRecord.setResult(approveParam.getResult());
        approveRecord.setRemark(approveParam.getRemark());
        approveRecord.setApproveNodeType(approveParam.getApproveNodeType());
        approveRecord.setApproveNodeCode(approveParam.getApproveNodeCode());
        approveRecord.setApproveNodeName(approveParam.getApproveNodeName());
        approveRecord.setApproverUser(approveParam.getApproverUser());
        approveRecord.setApproverName(approveParam.getApproverName());
        approveRecord.setApproverMobile(approveParam.getApproverMobile());
        approveRecord.setRemark(approveParam.getRemark());
        approveRecord.setApproveTime(approveParam.getApproveTime());
        approveRecord.setCreateUser(approveParam.getApproverUser());
        approveRecord.setCreateTime(LocalDateTime.now());
        approveRecord.setAttachList(approveParam.getAttachList());
        return approveRecord;
    }
}
