package com.rocogz.merchant.entity.customer.workflow.apply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 产品入库申请审批附件信息表</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 16:30</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("merchant_customer_goods_instore_apply_attach")
public class GoodsInstoreApplyAttach extends IdEntity {

    /**
     * 申请编号
     */
    private String applyCode;

    /**
     * 审批记录Id编号（审批附件专有字段）
     *
     * @see GoodsInstoreApply#id
     */
    private Integer approveRecordId;

    /**
     * 上传的附件名
     */
    private String uploadName;

    /**
     * 上传的附件路径
     */
    private String path;

    /**
     * 附件大小
     */
    private Integer fileSize;

    /**
     * 附件说明
     */
    private String description;

    /**
     * 附件顺序
     */
    private Integer seq;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
