package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 过期补发申请明细表
 * </p>
 *
 * @author yinshihao
 * @since 2022-03-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmReissueApplyDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请明细单号
     */
    private String applyDetailCode;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 原上游订单编号
     */
    private String oldUpOrderCode;

    /**
     * 原下游订单编号
     */
    private String oldDownOrderCode;

    /**
     * 原下单业务号
     */
    private String oldBusinessCode;

    /**
     * 旧使用生效日期
     */
    private LocalDateTime oldUseEffectiveDate;

    /**
     * 旧使用失效日期
     */
    private LocalDateTime oldUseInvalidDate;

    /**
     * 旧领取生效日期
     */
    private LocalDateTime oldEffectiveDate;

    /**
     * 旧领取失效日期
     */
    private LocalDateTime oldInvalidDate;

    /**
     * 延期天数(可以手动填写,也可以根据上游订单有效期配置中获取)
     */
    private Integer delayDays;

    /**
     * 延期类型(RECEIVE_DELAY:领取有效期延期, USE_DELAY:使用有效期延期)
     */
    private String delayType;

    /**
     * 新使用生效日期
     */
    private LocalDateTime newUseEffectiveDate;

    /**
     * 新使用失效日期
     */
    private LocalDateTime newUseInvalidDate;

    /**
     * 新领取生效日期
     */
    private LocalDateTime newEffectiveDate;

    /**
     * 新领取失效日期
     */
    private LocalDateTime newInvalidDate;

    /**
     * 处理完成时间(包括延期完成时间和补发完成时间)
     */
    private LocalDateTime completionDate;

    /**
     * 补发类型(ALL:全部补发、PART:部分补发, 申请类型为补发时才有)
     */
    private String reissueType;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 补发金额(申请类型为补发时才有)
     */
    private BigDecimal reissueAmount;

    /**
     * 明细状态(PENDING:待处理、PROCESSING:处理中、PROCESSING_FAILED:处理失败、PROCESSED:已处理)
     */
    private String status;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 发放会员手机号,收用户券的会员手机号
     */
    private String mobile;

    /**
     * 发放会员证件信息
     */
    private String idCard;

    /**
     * 发放会员证件类型
     */
    private String idType;

    /**
     * 发放会员姓名
     */
    private String name;

    /**
     * 发放会员车牌
     */
    private String licenseNo;

    /**
     * 发放会员车架号
     */
    private String vinNo;

    /**
     * 发放会员保单号
     */
    private String policyNo;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    @TableField(exist = false)
    private String customerProductName;

    /**
     * 单位面值
     */
    private BigDecimal unitFaceValue;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    @TableField(exist = false)
    private String agentProductName;

    /**
     * 平台产品编号
     */
    private String platformProductCode;

    /**
     * 平台产品名称
     */
    @TableField(exist = false)
    private String platformProductName;

    /**
     * 扣减时点：DEDUCTION_ON_COLLECTION：领取时扣减，DEDUCTION_ON_ISSUE： 发放时扣减
     */
    private String dedutionTimePoint;

    /**
     * 扣款账户编号(取字典值中配置好的个人账户编号)
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放规则编码
     */
    private String grantRuleCode;

    /**
     * 领取规则编码
     */
    private String receiveRuleCode;

    /**
     * 发放目标平台编码
     */
    private String targetPlatformCode;

    /**
     * 发放主体编码
     */
    private String sourceCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 发放目标小程序ID
     */
    private String miniAppid;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 备付金扣减金额(扣减总额度)
     */
    private BigDecimal coverPrice;

    /**
     * 过期金额
     */
    private BigDecimal expireBalance;

    /**
     * 原基准券编号
     */
    private String couponCode;

    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;

    /**
     * 产品类别
     */
    private String productCategory;

    /**
     * 套餐明细编号
     */
    private String packageDetailCode;

    /**
     * 产品性质(单品/套餐)
     */
    private String  productNature;

    /**
     * 过期操作类型
     *
     * @see com.rocogz.merchant.constant.Constant.DictType.ORDER_DELAY_REISSUE_OPERATION
     */
    private String delayReissue;
}
