package com.rocogz.merchant.entity.scmWarehouse;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description:分销的仓库 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmWarehouse extends UserTimeEntity {

    private static final long serialVersionUID=1L;
    /**
     * 仓库编号，发号器生成
     */
    private String code;

    /**
     * 仓库名称
     */
    private String name;

    /**
     * 仓库类型:主体，合作客户，服务商，平台仓
     * @see ScmWarehouseConstant.DictScmWarehouseType#PLATFORM
     */
    private String type;

    /**
     *  状态分为(OPEN/LOCK)
     */
    private String status;

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 代理商编号
     */
    private String agentCode;

    //扩展
    /**
     * 发放主体名称-查询的是简称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 合作客户-查询的是简称
     */
    @TableField(exist = false)
    private String customerName;

    /**
     * 服务商-查询的是简称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 仓库分类名称
     */
    @TableField(exist = false)
    private String typeName;

    /**
     * 状态名称
     */
    @TableField(exist = false)
    private String statusName;
}
