package com.rocogz.merchant.entity.supplier;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 *  供应商日志
 * </p>
 *
 * @author yifenrui
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_supplier_ulog")
public class MerchantSupplierUlog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 操作项
     */
    private String ulogType;

    /**
     * 内容
     */
    private String ulogContent;

    /**
     * 操作人
     */
    private String ulogUser;

    /**
     * 操作时间
     */
    private LocalDateTime ulogTime;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 操作前状态
     */
    private String beforeStatus;

    /**
     * 操作后状态
     */
    private String afterStatus;


    /**
     * 用户名称
     */
    @TableField(exist = false)
    private String userName;


}
