package com.rocogz.merchant.request.validity;

import com.rocogz.merchant.request.log.OperationReq;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author djt
 * @date 2021/11/17
 */
@Data
public class ValidityRuleBaseSaveReq implements OperationReq {

    private Integer id;

    /**
     * 发放主体编号
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 有效期设置时点
     */
    @NotBlank
    private String settingTimePoint;

    /**
     * 生效方式（IMMEDIATE：立即生效、DELAY：延时生效）
     */
    @NotBlank
    private String effectiveRuleMode;

    /**
     * 生效方式: 延时生效天数（生效方式为延时生效时有值）
     */
    @Min(value = 1,message ="延时生效天数不能小于1" )
    private Integer effectiveDelayDays;

    /**
     * 失效方式：（CALC_BY_GOOD：取平台产品有效期天数计算、 DELAY：生效xx天后失效）
     */
    @NotBlank
    private String invalidRuleMode;

    /**
     * 失效方式: 生效延迟xx天后失效（失效方式为延时生效时有值）
     */
    @Min(value = 1,message ="失效延迟天数不能小于1" )
    private Integer invalidDelayDays;

    /**
     * 触发调用上游的方式(MANUAL：手动、AUTO:自动)
     */
    @NotBlank
    private String remoteTriggerMode;

    /**
     * 操作人
     */
    @NotNull
    private Integer operationUser;

    /**
     * 操作人姓名
     */
    @NotBlank
    private String operationUserName;


    @Override
    public String getOperationName() {
        return this.operationUserName;
    }

    @Override
    public Integer getOperationId() {
        return this.operationUser;
    }
}
