package com.rocogz.syy.oilc.dto.order;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 实时计算价格接口的返回值</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/6/1 17:50</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class CalculateAmountResp {
    /**
     * 加油升数
     */
    private Double liter;
    /**
     * 立减优惠后的支付金额，单位：元，如 195
     */
    private BigDecimal amountPay;

    /**
     * 加油金额
     */
    private BigDecimal amountOrder;

    /**
     * 好车主价直降金额
     */
    private BigDecimal amountDiscounts;

    /**
     * 机构会员价直降金额
     */
    private BigDecimal orgVipDepreciateAmount;

}
