package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.oilc.constant.OilCConstant;
import com.rocogz.syy.oilc.enumeration.OrderOperationTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单操作日志水
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order_log")
public class OilcOrderLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 操作
     */
    private String action;

    /**
     * 操作前状态
     */
    private String beforeStatus;

    /**
     * 操作后状态
     */
    private String afterStatus;

    /**
     * 操作人名字
     */
    private String actionUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作说明
     */
    private String remark;

    public OilcOrderLog fillingActionByAfterStatus() {
        switch (this.afterStatus) {
            case OilCConstant.OrderStatus.CANCEL:
                this.action = OrderOperationTypeEnum.CANCEL.getLabel();
                return this;
            case OilCConstant.OrderStatus.IN_RECALL:
                this.action = OrderOperationTypeEnum.RECALL.getLabel();
                return this;
            case OilCConstant.OrderStatus.RECALL:
                this.action = OrderOperationTypeEnum.RECALL_SUCCESS.getLabel();
                return this;
            case OilCConstant.OrderPayStatus.PENDING_REFUND:
                this.action = OrderOperationTypeEnum.REFUND_APPLY.getLabel();
                return this;
            case OilCConstant.OrderPayStatus.REFUNDING:
                this.action = OrderOperationTypeEnum.REFUND.getLabel();
                return this;
            case OilCConstant.OrderPayStatus.REFUND_SUCCESS:
                this.action = OrderOperationTypeEnum.REFUND_SUCCESS.getLabel();
                return this;
            case OilCConstant.OrderPayStatus.REFUND_FAIL:
                this.action = OrderOperationTypeEnum.REFUND_FAIL.getLabel();
                return this;
            default:
                return this;
        }
    }

}
