package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单退款信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order_refund")
public class OilcOrderRefund extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 退款记录编号(oilc)
     */
    private String refundCode;

    /**
     * 支付记录编号(oilc)
     */
    private String payCode;

    /**
     * 加油订单编号(oilc)
     */
    private String orderCode;

    /**
     * 外部加油订单编号(oilc、平安订单编号)
     */
    private String outOrderCode;

    /**
     * 交易流水号(以下都是第三方支付的字段)
     */
    private String tradeId;

    /**
     * 退款流水号
     */
    private String refundId;

    /**
     * 第三方退款、退货流水号，不长于30位，第三方全局唯一
     */
    private String outRefundId;

    /**
     * 撤销金额(第三方平台返回的是分，这里为了保持和支付接口一直，转换为元)
     */
    private BigDecimal refundAmount;

    /**
     * 渠道商户编号
     */
    private String mrchntCode;

    /**
     * 商户名称
     */
    private String mrchntName;

    /**
     * 渠道终端编号
     */
    private String terCode;

    /**
     * 交易状态：0-退款中 1-退款成功 2-退款失败
     */
    private Integer status;

    /**
     * 设备号、虚拟设备号
     */
    private String sn;

    /**
     * 退款备注
     */
    private String remark;

    /**
     * 退款时间
     */
    private LocalDateTime refundTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
