package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 账户事件
 *
 * @author Andrew
 * @create 2020/8/7
 */
@RequiredArgsConstructor
public enum AccountEventType {
    
    /**
     * 顶级账户，直接收回
     */
    SYS_DECR("集成商收回"),
    
    /**
     * 顶级账户， 直接增加
     */
    SYS_ADD("集成商划拨"),
    
    /**
     * 上级总 -> 下级总
     */
    TRANS_CHILD("划拨下级机构总账户"),
    
    /**
     * 上级总 <- 下级总
     */
    TRANS_CHILD_BACK("收回下级机构总账户"),
    
    /**
     * 总 -> 明
     */
    TRANS_DETAIL("划拨机构明细账户"),
    
    /**
     * 总 <- 名
     */
    TRANS_DETAIL_BACK("收回机构明细账户"),
    
    /**
     *  余额->冻结
     */
    GIFT_APPROVED("礼品发放审核"),
    
    /**
     * 冻结->余额
     */
    GIFT_INVALID("礼品发放作废"),
    
    /**
     * 冻结->已用
     */
    GIFT_RECHARGE("礼品发放"),
    
    /**
     * 已用->余额
     */
    GIFT_REVOKE("礼品发放撤回");
    
    @Getter
    private final String label;
    
    
}
