package com.rocogz.account.api.request.account.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 额度同步
 *
 * @author Andrew
 * @create 2020/8/19 1:39 下午
 */
@Data
public class AccountAmountSyncReq implements Serializable {
    
    
    @NotBlank
    private String acctNo;
    /**
     * 余额
     */
    @NotNull
    private BigDecimal balance;
    
    /**
     * 已用金额
     */
    @NotNull
    private BigDecimal usedAmount;
    
    /**
     * 冻结金额
     */
    @NotNull
    private BigDecimal frozenAmount;
    
    /**
     * 转出额度
     */
    @NotNull
    private BigDecimal transferAmount;
    
    @Length(max = 1024)
    private String remark;
    
}
