package com.rocogz.account.api.service.account;

import com.rocogz.account.api.request.account.trade.AccountAmountSyncReq;
import com.rocogz.account.api.request.account.trade.AccountTradeReq;
import com.rocogz.account.api.request.account.trade.AccountTransGeneralReq;
import com.rocogz.account.api.response.account.trade.AccountSysTradeRes;
import com.rocogz.account.api.response.account.trade.AccountTradeRes;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonResponse;

/**
 * 账户交易服务
 *
 * @author Andrew
 * @create 2020/4/8 3:36 下午
 */
public interface AccountTradeService {
    
    /**
     * 交易
     *
     * @param request
     * @return
     */
    CommonResponse<AccountTradeRes> trading(CommonRequest<AccountTradeReq> request);
    
    /**
     * 集成商划拨 + 机构划拨
     * @param request
     * @return
     */
    CommonResponse<AccountSysTradeRes> sysTrading(CommonRequest<AccountTradeReq> request);
    
    
    /**
     * 划拨到通用账户
     * @param request
     * @return
     */
    CommonResponse<AccountTradeRes> transGeneral(CommonRequest<AccountTransGeneralReq> request);
    
    
    /**
     * 额度同步
     * @param request
     * @return
     */
    CommonResponse<Boolean> syncAmount(CommonRequest<AccountAmountSyncReq> request);
}
