/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.enums.account.AccountAmountType;
import com.rocogz.account.api.enums.account.AccountTradeRecordType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="account_trade_record")
public class AccountTradeRecord
implements Serializable {
    @Id
    private Long id;
    private String tradeNo;
    private String acctNo;
    private String logNo;
    private String eventNo;
    private String eventType;
    private String recordType;
    private BigDecimal amount;
    private BigDecimal afterBalance;
    private BigDecimal afterFrozenAmount;
    private BigDecimal afterUsedAmount;
    private BigDecimal afterTransferAmount;
    private String remark;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    private LocalDateTime createTime;
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+08:00")
    private LocalDate createDate;
    private String createUsertype;
    private String createUser;
    private String createName;

    public String getBalanceChange() {
        return AccountTradeRecordType.getFlag(this.amount, AccountAmountType.BALANCE, this.recordType);
    }

    public String getFrozenChange() {
        return AccountTradeRecordType.getFlag(this.amount, AccountAmountType.FROZEN_AMOUNT, this.recordType);
    }

    public String getUsedChange() {
        return AccountTradeRecordType.getFlag(this.amount, AccountAmountType.USED_AMOUNT, this.recordType);
    }

    public String getTransferChange() {
        return AccountTradeRecordType.getFlag(this.amount, AccountAmountType.TRANSFER_AMOUNT, this.recordType);
    }

    public BigDecimal getAfterTotalAmount() {
        try {
            return this.afterBalance.add(this.afterFrozenAmount).add(this.afterTransferAmount).add(this.afterUsedAmount);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public String getAcctNo() {
        return this.acctNo;
    }

    public String getLogNo() {
        return this.logNo;
    }

    public String getEventNo() {
        return this.eventNo;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getAfterBalance() {
        return this.afterBalance;
    }

    public BigDecimal getAfterFrozenAmount() {
        return this.afterFrozenAmount;
    }

    public BigDecimal getAfterUsedAmount() {
        return this.afterUsedAmount;
    }

    public BigDecimal getAfterTransferAmount() {
        return this.afterTransferAmount;
    }

    public String getRemark() {
        return this.remark;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDate getCreateDate() {
        return this.createDate;
    }

    public String getCreateUsertype() {
        return this.createUsertype;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public String getCreateName() {
        return this.createName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setAcctNo(String acctNo) {
        this.acctNo = acctNo;
    }

    public void setLogNo(String logNo) {
        this.logNo = logNo;
    }

    public void setEventNo(String eventNo) {
        this.eventNo = eventNo;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public void setAfterFrozenAmount(BigDecimal afterFrozenAmount) {
        this.afterFrozenAmount = afterFrozenAmount;
    }

    public void setAfterUsedAmount(BigDecimal afterUsedAmount) {
        this.afterUsedAmount = afterUsedAmount;
    }

    public void setAfterTransferAmount(BigDecimal afterTransferAmount) {
        this.afterTransferAmount = afterTransferAmount;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setCreateDate(LocalDate createDate) {
        this.createDate = createDate;
    }

    public void setCreateUsertype(String createUsertype) {
        this.createUsertype = createUsertype;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountTradeRecord)) {
            return false;
        }
        AccountTradeRecord other = (AccountTradeRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tradeNo = this.getTradeNo();
        String other$tradeNo = other.getTradeNo();
        if (this$tradeNo == null ? other$tradeNo != null : !this$tradeNo.equals(other$tradeNo)) {
            return false;
        }
        String this$acctNo = this.getAcctNo();
        String other$acctNo = other.getAcctNo();
        if (this$acctNo == null ? other$acctNo != null : !this$acctNo.equals(other$acctNo)) {
            return false;
        }
        String this$logNo = this.getLogNo();
        String other$logNo = other.getLogNo();
        if (this$logNo == null ? other$logNo != null : !this$logNo.equals(other$logNo)) {
            return false;
        }
        String this$eventNo = this.getEventNo();
        String other$eventNo = other.getEventNo();
        if (this$eventNo == null ? other$eventNo != null : !this$eventNo.equals(other$eventNo)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$recordType = this.getRecordType();
        String other$recordType = other.getRecordType();
        if (this$recordType == null ? other$recordType != null : !this$recordType.equals(other$recordType)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$afterBalance = this.getAfterBalance();
        BigDecimal other$afterBalance = other.getAfterBalance();
        if (this$afterBalance == null ? other$afterBalance != null : !((Object)this$afterBalance).equals(other$afterBalance)) {
            return false;
        }
        BigDecimal this$afterFrozenAmount = this.getAfterFrozenAmount();
        BigDecimal other$afterFrozenAmount = other.getAfterFrozenAmount();
        if (this$afterFrozenAmount == null ? other$afterFrozenAmount != null : !((Object)this$afterFrozenAmount).equals(other$afterFrozenAmount)) {
            return false;
        }
        BigDecimal this$afterUsedAmount = this.getAfterUsedAmount();
        BigDecimal other$afterUsedAmount = other.getAfterUsedAmount();
        if (this$afterUsedAmount == null ? other$afterUsedAmount != null : !((Object)this$afterUsedAmount).equals(other$afterUsedAmount)) {
            return false;
        }
        BigDecimal this$afterTransferAmount = this.getAfterTransferAmount();
        BigDecimal other$afterTransferAmount = other.getAfterTransferAmount();
        if (this$afterTransferAmount == null ? other$afterTransferAmount != null : !((Object)this$afterTransferAmount).equals(other$afterTransferAmount)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDate this$createDate = this.getCreateDate();
        LocalDate other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        String this$createUsertype = this.getCreateUsertype();
        String other$createUsertype = other.getCreateUsertype();
        if (this$createUsertype == null ? other$createUsertype != null : !this$createUsertype.equals(other$createUsertype)) {
            return false;
        }
        String this$createUser = this.getCreateUser();
        String other$createUser = other.getCreateUser();
        if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
            return false;
        }
        String this$createName = this.getCreateName();
        String other$createName = other.getCreateName();
        return !(this$createName == null ? other$createName != null : !this$createName.equals(other$createName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountTradeRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tradeNo = this.getTradeNo();
        result = result * 59 + ($tradeNo == null ? 43 : $tradeNo.hashCode());
        String $acctNo = this.getAcctNo();
        result = result * 59 + ($acctNo == null ? 43 : $acctNo.hashCode());
        String $logNo = this.getLogNo();
        result = result * 59 + ($logNo == null ? 43 : $logNo.hashCode());
        String $eventNo = this.getEventNo();
        result = result * 59 + ($eventNo == null ? 43 : $eventNo.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $recordType = this.getRecordType();
        result = result * 59 + ($recordType == null ? 43 : $recordType.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $afterBalance = this.getAfterBalance();
        result = result * 59 + ($afterBalance == null ? 43 : ((Object)$afterBalance).hashCode());
        BigDecimal $afterFrozenAmount = this.getAfterFrozenAmount();
        result = result * 59 + ($afterFrozenAmount == null ? 43 : ((Object)$afterFrozenAmount).hashCode());
        BigDecimal $afterUsedAmount = this.getAfterUsedAmount();
        result = result * 59 + ($afterUsedAmount == null ? 43 : ((Object)$afterUsedAmount).hashCode());
        BigDecimal $afterTransferAmount = this.getAfterTransferAmount();
        result = result * 59 + ($afterTransferAmount == null ? 43 : ((Object)$afterTransferAmount).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDate $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        String $createUsertype = this.getCreateUsertype();
        result = result * 59 + ($createUsertype == null ? 43 : $createUsertype.hashCode());
        String $createUser = this.getCreateUser();
        result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
        String $createName = this.getCreateName();
        result = result * 59 + ($createName == null ? 43 : $createName.hashCode());
        return result;
    }

    public String toString() {
        return "AccountTradeRecord(id=" + this.getId() + ", tradeNo=" + this.getTradeNo() + ", acctNo=" + this.getAcctNo() + ", logNo=" + this.getLogNo() + ", eventNo=" + this.getEventNo() + ", eventType=" + this.getEventType() + ", recordType=" + this.getRecordType() + ", amount=" + this.getAmount() + ", afterBalance=" + this.getAfterBalance() + ", afterFrozenAmount=" + this.getAfterFrozenAmount() + ", afterUsedAmount=" + this.getAfterUsedAmount() + ", afterTransferAmount=" + this.getAfterTransferAmount() + ", remark=" + this.getRemark() + ", createTime=" + this.getCreateTime() + ", createDate=" + this.getCreateDate() + ", createUsertype=" + this.getCreateUsertype() + ", createUser=" + this.getCreateUser() + ", createName=" + this.getCreateName() + ")";
    }
}

