package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 创建提现订单 Dto
 * @author ranxiangfu
 * @date 2020/8/4
 */
@Setter @Getter @Accessors(chain = true)
public class CreateWithdrawalsOrderDto {

    /**
     * 会员编号 [必传]
     */
    @NotEmpty
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    @NotEmpty
    private String mobile;

    /**
     * 会员openid [必传]
     */
    @NotEmpty
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    @NotEmpty
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    @NotEmpty
    private String channel;

    /**
     * 消耗的虚拟货币总金额
     */
    @NotNull
    private BigDecimal usedVirtualCurrencyAmount;

    /**
     * 手续费
     */
    @NotNull
    private BigDecimal feeAmount;

    /**
     * 费率
     */
    @NotNull
    private BigDecimal feeRate;

    /**
     * 到账金额
     */
    @NotNull
    private BigDecimal amountToTheAccount;

    /**
     * 身份证姓名
     */
    @NotEmpty
    private String idName;

    /**
     * 身份证号码
     */
    @NotEmpty
    private String idCard;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     * @see OrderConstant.DictWithdrawalsWay
     */
    @NotEmpty
    private String withdrawalsWay;

    /**
     * 支付宝账户
     */
    private String alipayAccount;

    /**
     * 银行账户持卡人姓名
     */
    private String bankCardholderName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;
}

