package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 商户投保礼礼品商户预选结果
 * </p>
 *
 * @author liangyongtong
 * @since 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_item_good_ready")
public class MerchantInsuranceGiftItemGoodReady extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主订单编号 -> 投保方案编号
     */
    private String mainCode;

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 关联礼品编码
     */
    private String giftCode;

    /**
     * 关联类型:(套餐|项目|礼品|加油代金券 )
     */
    private String relateType;

    /**
     * 对应的关联数据编码
     */
    private String relateCode;

    /**
     * 对应的关联数据名称
     */
    private String relateName;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

    /**
     * 图片路径
     */
    @TableField(exist = false)
    private String imageUrl;

    /**
     * 可用商品库存，返回详情的时候会使用到
     */
    @TableField(exist = false)
    private Integer goodsStock;

    /**
     * 前端方案明细颜色变化标志
     */
    @TableField(exist = false)
    private boolean fontGray = true;

    /**
     * 前端商品类型的明细小计结算价
     */
    @TableField(exist = false)
    private BigDecimal goodsSettlePrice;

    /**
     * 商品类型几选几中文
     */
    @TableField(exist = false)
    private String goodTypeName;

}
