package com.rocogz.syy.order.entity.oil;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.order.constant.OilTicketOrderConstant;
import com.rocogz.syy.order.constant.OilTicketOrderConstant.DictDepositStatus;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import com.rocogz.syy.order.util.ArithUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子加油券充值表
 * </p>
 *
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter @Accessors(chain = true)
public class OrderOilDeposit extends BaseUserInfo {

    /**
     * 油卡系统交易号/主订单号 [油卡系统订单创建成功后更新此字段]
     */
    private String tradeNo;

    /**
     * 加油电子券订单类型：纯券兑换 或 代金券+现金支付
     * @see OilTicketOrderConstant.DictOilTicketType
     */
    private String oilType;

    /**
     * 充值状态：如：待充值、充值中,充值完成 [刚创建时状态为null,油卡系统创建订单成功后更新为待充值]
     * 充值状态变化流程如下：
     * 创建OrderOilDeposit(NULL)-> 创建油卡系统单(待充值)-> 接收到充值结果回调(充值中) -> 充值完成
     * @see DictDepositStatus
     */
    private String depositStatus;

    /**
     * 充值金额
     */
    private BigDecimal depositAmt;

    /**
     * 到账业务笔数
     */
    private Integer successNum;

    /**
     * 到账金额
     */
    private BigDecimal successAmt;

    /**
     * 充值手机号
     */
    private String depositMobile;

    /**
     * 油卡系统创建订单失败后尝试次数：最多尝试5次,不包括第一次
     */
    private Integer retryTimes;

    /**
     * 油卡系统创建订单失败原因
     */
    private String failReason;

    /**
     * 油卡系统下单时间
     */
    private LocalDateTime tradeTime;

    /**
     * 最后一次尝试时间
     */
    private LocalDateTime retryTime;

    /**
     * 充值完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    //充值记录
    @TableField(exist = false)
    private List<OilDepositRecord> recordList;


    //支付时使用的核销码列表
    private transient List<String> writeOffCodeList;


    //方便为了页面展示
    private transient String depositStatusLabel;


    public String getFmtDepositAmt() {
        if(depositAmt == null) {
            return StringUtils.EMPTY;
        }

        return ArithUtil.getNoSymbolCurrency(depositAmt.doubleValue());
    }


    public String getFmtSuccessAmt() {
        if(successAmt == null) {
            return StringUtils.EMPTY;
        }
        return ArithUtil.getNoSymbolCurrency(successAmt.doubleValue());
    }



}
