package com.rocogz.syy.order.constant;

import java.io.Serializable;

/**
 * 投保礼
 * @author：liangyongtong
 * @since：2020/9/3
 */
public class InsuranceGiftConstant implements Serializable {

    /**
     * 字典表数据
     */
    public class DictData {
        /** 公共的状态 是 */
        public final static String COMMON_STATUS_YES = "Y";
        /** 公共的状态 否 */
        public final static String COMMON_STATUS_NO = "N";

        // 投保礼订单类型
        /** 商户端 */
        public final static String ORDER_TYPE_STORE = "STORE";
        /** 会员端 */
        public final static String ORDER_TYPE_MEMBER = "MEMBER";
        /** 方案 */
        public final static String ORDER_TYPE_PLAN = "PLAN";
        /** B端代理人 */
        public final static String ORDER_TYPE_AGENT = "AGENT";

        /** 方案类型:普通类型 */
        public final static String ORDER_PLAN_TYPE_COMMON = "COMMON";
        /** 方案类型:代理人定制类型 */
        public final static String ORDER_PLAN_TYPE_AGENT_CUSTOMIZED = "CUSTOMIZED";
        /** 方案类型: 标准套餐 */
        public final static String ORDER_PLAN_TYPE_AGENT_COMBO = "COMBO";

        // 设保礼礼品类型
        /** 设保礼礼品类型 套餐 **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE = "PACKAGE";
        /** 投保礼礼品类型 商品 */
        public static final String MERCHANT_INSURANCE_GIFT_TYPE_GOODS = "GOODS";
        /** 项目 **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT = "PROJECT";
        /** 代金券 **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON = "COUPON";
        /** 服务券 **/
        public static final String SERVICE_COUPON = "SERVICE";

        /** 加油代金券 **/
        public static final String OIL_CASH_COUPON = "OIL_CASH";

        /** 电子兑换券 **/
        public static final String OIL_CARD_COUPON = "OIL_CARD";

        /** 礼品状态： 待发货 */
        public final static String ORDER_ENTITY_STATUS_PENDING_DELIVERY = "PENDING_DELIVERY";
        /** 礼品状态： 待收货*/
        public final static String ORDER_ENTITY_STATUS_DELIVERED = "DELIVERED";
        /** 礼品状态： 已收货*/
        public final static String ORDER_ENTITY_STATUS_RECEIVED = "RECEIVED";
        /** 礼品状态： 未发券*/
        public final static String ORDER_VIRTUAL_STATUS_UNSENT = "UNSENT";
        /** 礼品状态： 已发券*/
        public final static String ORDER_VIRTUAL_STATUS_SENDED = "SENDED";

        /** 支付方式： 现金 */
        public final static String PAY_WAY_CASH = "CASH";
        /** 支付方式： 备付金 */
        public final static String PAY_WAY_COVER = "COVER";

        /** 套餐性质：标准 */
        public final static String COMBO_NATURE_STANDARD = "STANDARD";
        /** 套餐性质：自制 */
        public final static String COMBO_NATURE_HOMEMADE = "HOMEMADE";

        /** 礼品多选一：纯商品 */
        public final static String PLAN_MODEL_ONLY_GOODS = "ONLY_GOODS";
        /** 礼品多选一：含现金 */
        public final static String PLAN_MODEL_WITH_CASH = "WITH_CASH";
        /** 礼品多选一：打净 */
        public final static String PLAN_MODEL_POKER = "POKER";
        /** 礼品组合：纯商品组合 */
        public final static String PLAN_MODEL_GOODS_GROUP = "GOODS_GROUP";
        /** 礼品组合：商品 + 现金 */
        public final static String PLAN_MODEL_GOODS_CASH = "GOODS_CASH";

        /** 处理状态：待确认 */
        public final static String HANDLE_STATUS_CONFIRMED = "CONFIRMED";
        /** 处理状态：待支付 */
        public final static String HANDLE_STATUS_PAID = "PAID";
        /** 处理状态：处理中 */
        public final static String HANDLE_STATUS_PROCESSING = "PROCESSING";
        /** 处理状态：完成 */
        public final static String HANDLE_STATUS_COMPLETED = "COMPLETED";
        /** 处理状态：已作废 */
        public final static String HANDLE_STATUS_VOID = "VOID";

        /** 方案日志： 创建 */
        public static final String PLAN_OP_CREATE = "CREATE";
        /** 方案日志： 发送 */
        public static final String PLAN_OP_SEND = "SEND";
        /** 方案日志： 浏览 */
        public static final String PLAN_OP_BROWSE = "BROWSE";
        /** 方案日志： 确认 */
        public static final String PLAN_OP_CONFIRMED = "CONFIRMED";
        /** 方案日志： 支付 */
        public static final String PLAN_OP_PAID = "PAID";
        /** 方案日志： 赠送 */
        public static final String PLAN_OP_GIVING = "GIVING";
        /** 方案日志： 领取 */
        public static final String PLAN_OP_RECEIVE = "RECEIVE";
        /** 方案日志： 作废 */
        public static final String PLAN_OP_VOID = "GIFT_VOID";

        // 投保礼订单状态
        /** 报价中 */
//        public final static String INSURANCE_GIFT_INSUREING = "INSUREING";
        /** 处理中 */
//        public final static String INSURANCE_GIFT_PROCESSING = "PROCESSING";
        /** 已完成 */
//        public final static String INSURANCE_GIFT_COMPLETED = "COMPLETED";
        /** 已作废 */
//        public final static String INSURANCE_GIFT_INVALID = "INVALID";
    }

    /**
     * 排序类型
     */
    public class OrderBy {
        /** 智能排序 */
        public final static String AI = "AI";
        /** 预算从低到高 */
        public final static String BUDGETASC = "BUDGETASC";
        /** 预算从高到低 */
        public final static String BUDGETDESC = "BUDGETDESC";

        /** 市场从低到高 */
        public final static String MARKETASC = "MARKETASC";
        /** 市场从高到低 */
        public final static String MARKETDESC = "MARKETDESC";

        /** 成本从低到高 */
        public final static String COSTASC = "COSTASC";
        /** 成本从高到低 */
        public final static String COSTDESC = "COSTDESC";


    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /** 商户投保礼订单编码 **/
        public final static String MERCHANT_INSURANCE_GIFT_ORDER_CODE = "MERCHANT_INSURANCE_GIFT_ORDER_CODE";
    }
}
