package com.rocogz.syy.order.dto.evaluate;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 管理后台->评价查询 搜索 条件
 * @author zhangmin
 * @date 2020/5/12
 */
@Setter @Getter
public class AdminSearchEvaluationParamDto {
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 评价内容 搜索关键词
     */
    private String keyword;

    /**
     * 小程序appIds
     */
    private List<String> miniAppidList;

    /**
     * 专区编号
     */
    private List<String> areaCodes;

    /**
     * 专区服务编号
     */
    private List<String> areaServiceCodes;

    /**
     * 门店编号
     */
    private List<String> storeCodes;

    /**
     * 门店服务编号
     */
    private List<String> storeServiceCodes;

    /**
     * 评分
     */
    private BigDecimal score;


    /**
     * 是否匿名评价
     */
    private Boolean anonymous;

    /**
     * 评价状态[可见性]：1: 前端可见【默认】 2: 管理员设置为前端不可见  3:被逻辑删除
     */
    private Integer visible;

    /**
     * 是否精选
     */
    private Boolean perfect;

    /**
     * 下单时间
     */
    private String placeOrderStartTime;

    private String placeOrderEndTime;

    /**
     * 评价时间
     */
    private String evaluateStartTime;

    private String evaluateEndTime;

    public String getLikeKeyword() {
        if(StringUtils.isBlank(keyword)) {
            return null;
        }

        return "%" + keyword + "%";
    }

    private Integer limit = 20;

    private Integer page = 1;

}
