package com.rocogz.syy.order.dto.inspection;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 汽车检测站
 * @author djt
 * @date 2021/1/24
 */
@Data
public class CarCheckStation {

    /**
     * 监测站名称
     */
    @NotBlank
    private String name;

    /**
     * 监测站唯一标识
     */
    @NotBlank
    private String identify;

    /**
     * 检测站经度
     */
    @NotNull
    private BigDecimal longitude;

    /**
     * 监测站维度
     */
    @NotNull
    private BigDecimal latitude;

    /**
     * 检测站地址
     */
    private String address;

}
