package com.rocogz.syy.order.dto.inspection;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;

/**
 * @author djt
 * @date 2021/1/21
 */
@Data
public class CarInspectionExemptionCreateDTO  {


    /**
     * 车牌号
     */
    @Length(max = 32)
    @NotBlank
    private String  plateNumber;

    /**
     * 车辆类型
     */
    @Length(max = 32)
    @NotBlank
    private String carType;

    /**
     * 车辆性质； 1个人车，2公司车
     */
    @NotNull
    private Integer carProperty;


    /**
     * 车辆初次登记日期
     */
    @NotNull
    private LocalDate registerTime;

    /**
     * 是否七座以下，0七座以下 1七座或以上
     */
    @NotNull
    private Integer carSeat;


    /**
     * 车架号后6位
     */
    @NotNull
    private Integer frameNumber;

    /**
     * 发动机号后6位
     */
    @NotNull
    private Integer engineNumber;

    /**
     * 行驶证正面图片
     */
    private String vehicleDrivingLicenseFrontImage;

    /**
     * 行驶证反面图片
     */
    private String vehicleDrivingLicenseBackImage;

    /**
     * 交强险副本照片
     */
    private String compulsoryInsuranceImage;

    /**
     * 车主姓名
     */
    @Length(max = 32)
    @NotNull
    private String consignee;


    /**
     * 收货人手机号
     */
    private String deliveryMobile;

    /**
     * 收货人
     */
    private String addressee;

    /**
     * 地址-省份
     */
    private String addressProvince;

    /**
     * 地址-城市
     */
    private String addressCity;

    /**
     * 地址-区/县
     */
    private String addressDistrict;

    /**
     * 地址-街道门牌号等信息
     */
    private String addressStreet;

    /**
     * 完整地址
     */
    private String fullAddress;

    /**
     * 是否到付
     */
    @NotNull
    private Integer freight;
}
