package com.rocogz.syy.order.dto.inspection;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 代金券+现金支付的年审订单，我们这边支付成功后到鼎聚系统创建充值订单
 */
@Setter
@Getter
@ToString
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateDingJuCarInspectionOrderMsg {

    /**
     * 权益编号
     */

    private String pwNo;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车辆类型
     */
    private String carType;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 商户订单号
     */
    private String outOrderId;

    /**
     * 预约年检日期(如：2020-02-19)
     */
    private LocalDate appointTime;

    /**
     * 客户姓名
     */
    private String consignee;

    /**
     * 取车地址(除自驾外都需填写)
     */
    private String userLoc;

    /**
     * 预约接车时间(除自驾外都需填写 如：2020-02-19 08:30:00)
     */

    private LocalDateTime userTime;


    /**
     * 监测站唯一标识
     */
    private String Identify;


    /**
     * 报价
     */
    private String price;


    /**
     * 行驶证正页
     */
    private String drivingLicense1;

    /**
     * 行驶证副页
     */
    private String drivingLicense2;


}
