package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @author：liangyongtong
 * @since：2020/10/27
 */
@Data
@Accessors(chain = true)
public class GiftStatusUpdateDto implements Serializable {

    /**
     * 意向单编码
     */
    private String itemCode;

    /**
     * 商品订单编码
     */
    private String orderCode;

    /**
     * 赠送编码
     */
    private String bestowCode;

    /**
     * 关联礼品编码
     */
    private List<String> relateCode;

    /**
     * 实体商品状态:
     * com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#ORDER_ENTITY_STATUS_PENDING_DELIVERY
     * com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#ORDER_ENTITY_STATUS_DELIVERED
     * com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#ORDER_ENTITY_STATUS_RECEIVED
     */
    private String entityGiftStatus;

    /**
     * 虚拟商品状态 :
     * com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#ORDER_VIRTUAL_STATUS_UNSENT
     * com.rocogz.syy.order.constant.InsuranceGiftConstant.DictData#ORDER_VIRTUAL_STATUS_SENDED
     */
    private String virtualGiftStatus;
}
