package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 商户投保礼创建订单入参对象
 * @author：liangyongtong
 * @since：2020/8/31
 */
@Data
public class MerchantInsuranceGiftMainOrderAdminPageDto implements Serializable {

    private static final long serialVersionUID = -1359427746550782744L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String code;

    /**
     * 方案编号
     */
    private String itemCode;

    /**
     * 方案模式
     */
    private String planModel;

    /**
     * 代理人
     */
    private String agentName;

    /**
     * 机构编码
     */
    private String orgCode;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 车牌号
     */
    private String license;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 投保方案状态
     */
    private String status;

    /**
     * 分页大小
     */
    private int limit = 20;

    /**
     * 当前页数
     */
    private int page = 1;

    /**
     * 下单渠道
     */
    private String orderType;

    /**
     * 方案类型
     */
    private String planType;

    /**
     * 下单人姓名
     */
    private String userName;

    /**
     * 下单人手机号
     */
    private String userMobile;

    /**
     * 下单人编码
     */
    private String userCode;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 方案预算排序
     */
    private String totalBudgetOrderBy;

    /**
     * 处理状态
     */
    private String handleStatus;

    /**
     * 处理状态
     */
    private String tabHandleStatus;

}
