package com.rocogz.syy.order.dto.insurancegift;

import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemDetailCombo;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftUser;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商户投保礼创建订单入参对象
 * @author：liangyongtong
 * @since：2020/8/31
 */
@Data
public class MerchantInsuranceGiftOrderDto implements Serializable {

    private static final long serialVersionUID = -5193369201190249777L;
    /**
     * 主订单编码
     */
    private String mainCode;

    /**
     * 二级订单编码
     */
    private String itemCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 方案类型
     */
    private String planType;

    /**
     * 方案模式
     */
    private String planModel;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 商户账号编码
     */
    private String storeAccountCode;

    /**
     * 商户账号名称
     */
    private String storeAccountName;

    /**
     * 商户openid
     */
    private String createOpenid;

    /**
     * 保险公司代码
     */
    private String companyCode;

    /**
     * 保险费率编码
     */
    private String rateCode;

    /**
     * 保险费率
     */
    private BigDecimal rate;

    /**
     * 保险公司名称
     */
    private String companyName;
    /**
     * 商业险费率
     */
    private BigDecimal vciRate;
    /**
     * 交强险费率
     */
    private BigDecimal tciRate;

    /**
     * 保险费用
     */
    private BigDecimal insurance;

    /**
     * 商户保险费用
     */
    private BigDecimal commercialInsurance;

    /**
     * 交强险费用
     */
    private BigDecimal interwovenInsurance;

    /**
     * 加投点数
     */
    private BigDecimal addCastPoint;

    /**
     * 预算
     */
    private BigDecimal budget;

    /**
     * 客户手机号
     */
    private String mobile;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 客户车牌号
     */
    private String license;

    /**
     * 礼赠说明
     */
    private String remark;

    /**
     * 现金
     */
    private BigDecimal cash;

    /**
     * 已选择礼品数
     */
    private Integer selected;

    /**
     * 客户需要选择礼品数
     */
    private Integer needSelect;

    /**
     * 方案名称
     */
    private String planName;

    /**
     * 可能的来源二级订单编码
     */
    private String sourcePlanCode;

    /**
     * 套餐性质
     */
    private String comboNature;

    /**
     * 礼品列表
     */
    private List<MerchantInsuranceGiftItemOrderDto> itemOrder;

    /**
     * 投保礼对应礼品价格设置列表
     */
    private List<MerchantInsuranceGiftDto> insuranceGifts;

    /**
     * 套餐对应的服务项目详情
     */
    private List<MerchantInsuranceGiftItemDetailCombo> detailCombos;

    /**
     * B端下单人信息
     */
    private MerchantInsuranceGiftUser user;
}
