package com.rocogz.syy.order.dto.jms;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 油卡充值订单，券的兑换情况
 * @author zhangmin
 * @date 2020/7/23
 */
@Setter
@Getter
@ToString
public class TicketExchangeReqDto {
    /**
     * 车服用户券核销码
     */
    private String rocoCouponNo;

    /**
     * 车服用户券码
     */
    private String rocoUserCouponNo;

    /**
     * 车服券面额
     */
    private String rocoCouponFaceValue;

    /**
     * 车服券使用订单号
     */
    private String rocoOrderNo;

    /**
     * 车服订单金额
     */
    private String rocoOrderAmount;

    /**
     * 车服下单时间
     */
    private String rocoOrderCreateTime;

    /**
     * 车服订单完成时间
     */
    private String rocoOrderFinishTime;

    /**
     * 用户支付金额 (代金券的时候)
     */
    private String rocoUserPayAmount;

    /**
     * 券类型电子兑换券:exchange 代金券:voucher
     */
    private String rocoCouponType;

    /**
     * 电子券简称例:10元代金券电子兑换券
     */
    private String rocoCouponSimpleName;

    /**
     * 订单说明: 如果是服务订单，取服务项目名称
     * 纯油卡加油券兑换订单：兑换中石化加油券
     * 代金券与现金合并支付的订单：充值中石化加油券
     */
    private String rocoSubject;

    /**
     * 车服订单手机号
     */
    private String rocoOrderMobile;

    /**
     * 状态码处理中: processing  完成: finish  备注:同步业务: 推送一次(finish)即可异步业务: 推送N次(processing), 一次(finish
     */
    private String status;

    /**
     * 状态描述
     */
    private String statusDesc;

    private List<TicketExchangeBizItem> bizList;

}
