package com.rocogz.syy.order.dto.oil;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 油卡电子加油券 到账详情页显示的DTO
 * @author zhangmin
 * @date 2020/7/23
 */
@Setter @Getter
public class OilTicketExchangeDetailDto {

    /**
     * roco车服订单号
     */
    private String orderCode;

    /**
     * 有效期-开始日期
     */
    private LocalDate minValidEndDate;

    /**
     * 有效期-结束日期
     */
    private LocalDate minValidStartDate;

    /**
     * 是否已到账
     */
    private Boolean finished;

    /**
     * 充值手机号
     */
    private String depositMobile;

    /**
     *会员手机号
     */
    private String userMobile;

    /**
     * 兑换时间：即创建roco车服订单时间
     */
    private LocalDateTime exchangeTime;

}
