package com.rocogz.syy.order.dto.peccancy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrderItem;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.stream.Collectors;

/**
 *  违约订单支付成功后,返回的对象
 * @author zhangmin
 * @date 2020/5/30
 */
@Setter @Getter @Accessors(chain = true)
public class PeccancyOrderPayedResultDto {

    /**
     * 成功支付的 违约订单号,即：商户订单号
     */
    private String orderCode;

    /**
     * 违章报价ID,多个ID用英文“,”隔开
     */
    private String peccancyIds;

    /**
     * 是否本人本证
     */
    private Boolean self;

    /**
     * 驾驶证号
     */
    private String licenseNumber;

    /**
     * 驾驶证档案编号
     */
    private String licenseFileNumber;

    /**
     * 驾驶证绑定手机号
     */
    private String licensePhoneNumber;


    @JsonIgnore
    private String userCode;


    public static PeccancyOrderPayedResultDto valueOf(OrderPeccancyOrder peccancyOrder) {
        PeccancyOrderPayedResultDto resultDto = new PeccancyOrderPayedResultDto();
        resultDto.setOrderCode(peccancyOrder.getOrderCode());
        resultDto.setLicenseFileNumber(peccancyOrder.getLicenseFileNumber());
        resultDto.setLicenseNumber(peccancyOrder.getLicenseNumber());
        resultDto.setLicensePhoneNumber(peccancyOrder.getLicensePhoneNumber());
        resultDto.setUserCode(peccancyOrder.getUserCode());
        resultDto.setSelf(peccancyOrder.getIsSelf());

        String peccancyIds = peccancyOrder.getItemList().stream().map(OrderPeccancyOrderItem::getPeccancyId)
                .collect(Collectors.joining(","));

        resultDto.setPeccancyIds(peccancyIds);

        return resultDto;
    }

}
