package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;

/**
 * 管理后台-> 提现订单 搜索 条件
 * @author ranxiangfu
 * @date 2020/8/4
 */
@Data
public class WithdrawalsAdminSearchParamDto extends AdminBaseSearchDto  {

    public WithdrawalsAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.WITHDRAWALS_ORDER);
    }

    /**
     * 收款人姓名
     */
    private String idName;

    /**
     * 收款账户
     */
    private String account;

    /**
     * 提现状态: PENDIND-待审批; PENDIND_PROCESS-(已受理/待处理); REFUSE-(未受理/审核不通过);
     *      PROCESSING-(转账中/处理中); SUCCESS-提现成功; FAIL-提现失败;
     */
    private String withdrawalsStatus;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     */
    private String withdrawalsWay;

    /**
     * 更新时间起始
     */
    private String updateStartTime;

    /**
     * 更新时间结束
     */
    private String updateEndTime;
}
