package com.rocogz.syy.order.entity.appoint;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import com.rocogz.syy.order.util.AppointUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单预约信息
 * </p>
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter @Accessors(chain = true)
public class OrderAppointment extends BaseUserInfo {

    /**
     * 预约人手机号：用来关联车主端会员信息
     */
    private String appointMobile;

    /**
     * 预约人
     */
    private String appointUser;

    /**
     * 预约的门店编号
     */
    private String storeCode;

    /**
     * 预约车牌号
     */
    private String carLicense;

    /**
     * 第三方平台订单号（如果是通过第三方平台预约下单）例如：人保车务订单号
     */
    private String thirdOrderCode;

    /**
     * 第三方平台 订单核销码; 如:ODA6L55849
     * 车务平台 扫码后的识别出来的内容
     * http://{picccarshoptest.rocoinfo.cn}/login/jump/qr?redeemcode={ODA6L55849}
     */
    @TableField("third_writeoff_code")
    private String thirdWriteOffCode;

    /**
     * 预约开始时间 例如：2020-07-12 12:20:00
     */
    private LocalDateTime startTime;

    /**
     *预约结束时间  例如：2020-07-12 12:50:00
     */
    private LocalDateTime endTime;

    /**
     * @return 2010-11-21 10:10-13:20
     */
    public String getAppointDateTimeRange() {
        return AppointUtil.concatAppointDateTimeRange(startTime,endTime);
    }
}
