package com.rocogz.syy.order.entity.evaluate;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单评价 之 服务指标评分
 * </p>
 * @author zhangmin
 * @since 2020-05-20
 */
@Setter @Getter
@Accessors(chain = true)
@TableName("order_evaluate_kpi")
public class EvaluateKpi extends BaseEvaluate {

    public EvaluateKpi() {
    }

    public EvaluateKpi(String kpiCode, String kpiName) {
        this(kpiCode,kpiName,null);
    }

    public EvaluateKpi(String kpiCode, String kpiName, Integer score) {
        this.kpiCode = kpiCode;
        this.kpiName = kpiName;
        this.score = score;
    }

    /**
     * 评价的服务指标
     */
    private String kpiCode;

    /**
     * 评价的服务指标名
     */
    private String kpiName;

    /**
     * 评分 1-5
     */
    private Integer score;

}
