package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商品订单(B端代理人)下单人信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order_agent_user_info")
public class GoodsOrderAgentUserInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 下单人编码
     */
    private String userCode;

    /**
     * 下单人名称
     */
    private String userName;

    /**
     * 下单人手机号
     */
    private String userMobile;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 团队名称
     */
    private String teamName;

    /**
     * 机构编码
     */
    private String orgCode;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 代理商编码
     */
    private String agentCode;

    /**
     * 代理商名称
     */
    private String agentName;

    /**
     * 投保礼方案编号
     */
    private String planCode;

    /**
     * 投保礼方案类型
     */
    @TableField(exist = false)
    private String planType;

    /**
     * 投保礼方案模式
     */
    @TableField(exist = false)
    private String planModel;
}
