package com.rocogz.syy.order.entity.inspection;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import com.rocogz.util.DateUtil;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2021/1/20 20:3</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@TableName("order_car_inspection_order")
public class CarInspectionOrder extends IdEntity {


    /**
     * 订单编号(order_sale_order.order_code)
     */
    private String orderCode;

    /**
     * 鼎聚权益号
     */
    private String powerNo;

    /**
     * 鼎聚订单编号
     */
    private String thirdPlatformOrderCode;

    /**
     * @see com.rocogz.syy.order.constant.OrderConstant.DictCarInspectionOrderType
     * 订单类型
     */
    private String inspectionType;

    /**
     * 支付总金额
     */
    private BigDecimal totalAmount;


    /**
     * 用户支付现金总金额
     */
    private BigDecimal cashAmount;


    /**
     * 退款金额
     */
    private BigDecimal refundAmount;


    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车主姓名
     */
    private String consignee;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 车辆类型
     */
    private String carType;

    /**
     * 车辆性质； 1个人车，2公司车
     */
    private Integer carProperty;

    /**
     * 车辆初次登记日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate registerTime;

    /**
     * 预约年检日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate appointTime;

    /**
     * 是否七座以下，0七座以下 1七座或以上
     */
    private Integer carSeat;

    /**
     * 车架号后6位
     */
    private Integer frameNumber;

    /**
     * 发动机号后6位
     */
    private Integer engineNumber;

    /**
     * 行驶证正面图片
     */
    private String vehicleDrivingLicenseFrontImage;

    /**
     * 行驶证反面图片
     */
    private String vehicleDrivingLicenseBackImage;

    /**
     * 交强险副本照片
     */
    private String compulsoryInsuranceImage;


    /**
     * @see com.rocogz.syy.order.constant.OrderConstant.DictCarInspectionYearMode
     * 年审模式
     */
    private String inspectionYearMode;

    /**
     * 检测站唯一标识
     */
    private String checkStationIdentify;

    /**
     * 检测站名称
     */
    private String checkStationName;

    /**
     * 监测站地址
     */
    private String checkStationAddress;

    /**
     * 检测站经度
     */
    private BigDecimal longitude;


    /**
     * 检测站维度
     */
    private BigDecimal latitude;

    /**
     * 取车地址
     */
    private String carLocation;

    /**
     * 预约接车时间
     */
    private LocalDateTime carTime;

    /**
     * 给客户寄回快递公司名称
     */
    private String expressDeliveryName;

    /**
     * 给客户寄回快递单号
     */
    private String expressDeliveryNumber;

    /**
     * 是否到付
     */
    private Integer freight;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime finishTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 鼎聚订单状态：1、预约中；2、办理中；3、已完成;4：平台取消；5、已退款
     */
    private Integer thirdPlatformOrderStatus;

    /**
     * 备付金扣减金额(鼎聚返回)
     */
    private BigDecimal advancePaymentDeduction;

    /**
     * 创建订单失败后尝试次数
     */
    private Integer retryTimes;

    /**
     * 下单失败原因
     */
    private String failReason;

    /**
     * 第三方平台订单创建时间
     */
    private LocalDateTime thirdPlatformOrderCreateTime;

    /**
     * 退款时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime refundTime;

    /**
     * 最后一次尝试时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime retryTime;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;


    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;


    /**
     * 快递地址
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress orderDeliveryAddress;

    // 以下字段用于显示
    private transient String carTypeLabel;
    private transient String thirdPlatformOrderStatusLabel;
    private transient String inspectionYearModeLabel;
    private transient String carPropertyLabel;

}