package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 投保礼套餐对应的商户服务项目（快照）
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_item_detail_combo")
public class MerchantInsuranceGiftItemDetailCombo extends IdEntity {

    private static final long serialVersionUID = 1520121469985500809L;
    /**
     * 投保礼主订单
     */
    private String mainCode;

    /**
     * 投保礼二级订单编码
     */
    private String itemCode;

    /**
     * 关联的礼品编码
     */
    private String giftCode;

    /**
     * 商户服务项目编码
     */
    private String storeServiceCode;

    /**
     * 商户服务项目名称
     */
    private String storeServiceName;

    /**
     * 数量
     */
    private int amount;
}
