package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 商户投保礼礼品商户预选统计结果
 * </p>
 *
 * @author liangyongtong
 * @since 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_item_good_statistics")
public class MerchantInsuranceGiftItemGoodStatistics extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主订单编号 -> 投保方案编号
     */
    private String mainCode;

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 已选择礼品数
     */
    private Integer selected;

    /**
     * 客户需要选择礼品数
     */
    private Integer needSelect;

    /**
     * 成本价最低
     */
    private BigDecimal costLeast;

    /**
     * 成本价最高
     */
    private BigDecimal costMaximum;

    /**
     * 市场价最低
     */
    private BigDecimal marketLeast;

    /**
     * 市场价最高
     */
    private BigDecimal marketMaximum;

    /**
     * 膨胀率最低
     */
    private BigDecimal inflationRateLeast;

    /**
     * 膨胀率最高
     */
    private BigDecimal inflationRateMaximum;

    /**
     * 节省最低
     */
    private BigDecimal preferentialAmountLeast;

    /**
     * 节省最高
     */
    private BigDecimal preferentialAmountMaximum;

}
