package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 方案日志流水
 * </p>
 *
 * @author liangyongtong
 * @since 2020-12-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_log")
public class MerchantInsuranceGiftLog extends IdEntity {

    private static final long serialVersionUID = -1120898063923634011L;
    /**
     * 二级订单编码
     */
    private String itemCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 操作类型
     */
    private String opType;

    /**
     * appid
     */
    private String appid;

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 名称
     */
    private String name;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String profilePhoto;

    /**
     * openid
     */
    private String openid;

    /**
     * 操作时间
     */
    private LocalDateTime opTime;

    /**
     * 次数
     */
    @TableField(exist = false)
    private int num;
}
