package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.collect.Lists;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 退款单
 * </p>
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter @Accessors(chain = true)
public class OrderRefund extends BaseUserInfo {

    /**
     * 支付单号
     */
    private String payCode;

    /**
     * 退款单号
     */
    private String refundCode;

    /**
     * 退款状态：退款中、已退款
     * @see OrderConstant.DictRefundStatus
     */
    private String refundStatus;

    /**
     * 退款原因描述
     */
    private String refundReason;

    /**
     * 退款金额
     */
    private BigDecimal refundAmt;

    /**
     * 已成功退款金额
     */
    private BigDecimal successAmt;

    /**
     * 完成退款时间
     */
    private LocalDateTime finishTime;

    /**
     * 发起退款操作人
     */
    private String createUser;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 修改人
     */
    private String updateUser;


    /**
     * 退款记录列表
     */
    @TableField(exist = false)
    private List<OrderRefundRecord> recordList;



    public void addRecord(OrderRefundRecord record) {
        if(record!=null) {
            if(recordList == null) {
                recordList = Lists.newArrayList();
            }
            recordList.add(record);
        }
    }

}
