package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;

import static com.rocogz.syy.order.constant.OrderConstant.DictWriteOffWay;

/**
 * <p>
 * 订单核销信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_writeoff")
@Setter @Getter @ToString
@Accessors(chain = true)
public class OrderWriteOff extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 订单编号
     */
    @UniqueField
    private String orderCode;

    /**
     * 核销方式：商户端扫码，商户端输入，后台手工核销
     *
     * @see DictWriteOffWay
     */
    private String writeWay;

    /**
     * 用户券核销码
     */
    @TableField("writeoff_code")
    private String writeOffCode;

    /**
     * 核销车辆类型：CAR("小型车"),SUV,MPV,OTHER("其他车型"),ALL("不区分车型")
     * basic_dict_data 表中 AREA_SERVICE_CAR_TYPE类型的字典数据
     */
    private String carType;

    /**
     * 核销车牌号码
     */
    private String carLicense;

    /**
     * 核销人(商户核销)
     */
    private String storeAccountCode;

    /**
     * 核销人（后台手工核销）
     */
    private String adminCode;

    /**
     * 核销时间
     */
    private LocalDateTime writeTime;


    //获得核销人
    public String getWriteUser() {
        if(DictWriteOffWay.ADMIN_MANUAL.equals(writeWay)) {
            if(StringUtils.isEmpty(adminCode)) {
                return "后台账号";
            }else {
                return  "后台账号（" + adminCode + "）";
            }
        }

        return "商户账号("+storeAccountCode+")";
    }


    //以下 方便页面显示
    private transient String carTypeLabel;
    private transient String writeWayLabel;

}
