package com.rocogz.syy.order.entity.peccancy;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.order.constant.PeccancyConstant;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 违章订单信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-07-28
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderPeccancyOrder extends BaseUserInfo {

    /**
     * 鼎聚订单号
     */
    private String dingjuOrderCode;

    /**
     * 是否本人本证
     */
    private Boolean isSelf;

    /**
     * 驾驶人
     */
    private String driver;

    /**
     * 驾驶证号
     */
    private String licenseNumber;

    /**
     * 驾驶证档案编号
     */
    private String licenseFileNumber;

    /**
     * 驾驶证绑定手机号
     */
    private String licensePhoneNumber;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 鼎聚订单状态:(1:预约中；2:办理中；3:办理中；4:已完成；5:已取消；6:已完成；7:已完成)
     * @see PeccancyConstant.DictState
     */
    private String state;

    /**
     * 车架号后6位
     */
    private String frameNumber;

    /**
     * 发动机后6位
     */
    private String engineNumber;

    /**
     * 车辆性质 1:个人车  2:单位车
     * @see PeccancyConstant.DictCarProperty
     */
    private String carProperty;

    /**
     * 鼎聚车辆类型
     * @see PeccancyConstant.DictDingJuCarType
     */
    private String carType;

    /**
     * 订单总金额:即需要支付的金额
     */
    private BigDecimal totalAmount;

    /**
     * 总罚款金额
     */
    private BigDecimal fineAmount;

    /**
     * 总服务费
     */
    private BigDecimal otherAmount;

    /**
     * 创建鼎聚订单失败后尝试次数：最多尝试5次,不包括第一次
     */
    private Integer retryTimes;

    /**
     * 鼎聚系统创建订单失败原因
     */
    private String failReason;

    /**
     * 在鼎聚系统成功下单时间
     */
    private LocalDateTime dingjuCreateTime;

    /**
     * 最后一次尝试时间
     */
    private LocalDateTime lastRetryTime;

    /**
     * 修改时间: 鼎聚订单状态回调时间
     */
    private LocalDateTime updateTime;

    @TableField(exist = false)
    private List<OrderPeccancyOrderItem> itemList;

    //以下字段是订单详情页面显示字段
    private transient String stateLabel;
    private transient String carTypeLabel;
    private transient String carPropertyLabel;

    //违章Item个数
    private transient Integer itemNum;
}
