package com.rocogz.syy.order.util;

import com.rocogz.util.DateUtil;
import org.apache.commons.lang3.StringUtils;

import java.sql.SQLOutput;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * @author zhangmin
 * @date 2020/6/13
 */
public final class AppointUtil {

    static final String HM_PATTERN = "HH:mm";

    private AppointUtil() {
    }


    /**
     * @param timeRange 2010-11-12 09:01-11:30
     *                  解析开始和结束日期
     */
    public static LocalDateTime[] parseStartEndTime(String timeRange) {

        int idx = timeRange.lastIndexOf("-");

        String startTimeStr = timeRange.substring(0, idx);
        String endTimeStr = timeRange.substring(idx + 1, timeRange.length());
        LocalDateTime startTime = LocalDateTime.parse(startTimeStr.trim(), DateTimeFormatter.ofPattern(DateUtil.YYYY_MM_DD_HH_MM));
        LocalDateTime endTime = LocalDateTime.of(startTime.toLocalDate(), LocalTime.parse(endTimeStr, DateTimeFormatter.ofPattern(HM_PATTERN)));
        return new LocalDateTime[]{startTime, endTime};
    }


    /**
     * 拼接 预约时间
     *
     * @param startTime
     * @param endTime
     * @return 10:10-13:20
     */
    public static String concatAppointTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        LocalTime start = startTime.toLocalTime();
        LocalTime end = endTime.toLocalTime();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern(HM_PATTERN);
        String startStr = start.format(pattern);
        String endStr = end.format(pattern);
        return startStr + "-" + endStr;
    }


    /**
     * 拼接预约时间
     *
     * @param startTime
     * @param endTime
     * @return 2010-11-21 10:10-13:20
     */
    public static String concatAppointDateTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        if(startTime == null || endTime ==null) {
            return StringUtils.EMPTY;
        }

        String timePart = concatAppointTimeRange(startTime, endTime);
        String datePart = startTime.toLocalDate().format(DateTimeFormatter.ofPattern(DateUtil.YYYY_MM_DD));
        return datePart + " " + timePart;
    }
}
