package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单的服务项目信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderServiceItem extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    @UniqueField
    private String orderCode;

    /**
     * 专区服务项目编号 refence merchant_area_service(code)
     */
    private String areaServiceCode;

    /**
     * 商户服务项目编号 reference merchant_store_service(code)
     */
    private String storeServiceCode;

    /**
     * 商户服务项目名称, 现在保存的是 合作客户产品名称
     */
    private String storeServiceName;

    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

    /**
     * 服务分类编号 reference merchant_area_service(cata_code)
     */
    private String serviceCatalogCode;

    /**
     * 下单专区编号
     */
    private String areaCode;

    /**
     * 下单专区名称
     */
    private String areaName;

    /**
     * 服务所属商户编号
     */
    private String storeCode;

    /**
     * 行业编号 references merchant_store(industry_code)
     */
    private String industryCode;


    //以下字段 方便页面显示

    //服务所属商户名称
    private transient String storeName;
    //行业名称
    private transient String industryName;
    //服务分类名称
    private transient String serviceCatalogName;
    //专区服务项目名称
    private transient String areaServiceName;

}
