package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.dto.OrderUserCouponDto;
import com.rocogz.syy.order.dto.WriteOffUIParamDto;
import com.rocogz.syy.order.entity.evaluate.EvaluateAttach;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.List;

import static com.rocogz.syy.order.constant.OrderConstant.DictWriteOffWay;

/**
 * <p>
 * 订单核销信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_writeoff")
@Setter @Getter @ToString
@Accessors(chain = true)
public class OrderWriteOff extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 订单编号
     */
    @UniqueField
    private String orderCode;

    /**
     * 核销方式：商户端扫码，商户端输入，后台手工核销
     *
     * @see DictWriteOffWay
     */
    private String writeWay;

    /**
     * 用户券核销码
     */
    @TableField("writeoff_code")
    private String writeOffCode;

    /**
     * 核销车辆类型：CAR("小型车"),SUV,MPV,OTHER("其他车型"),ALL("不区分车型")
     * basic_dict_data 表中 AREA_SERVICE_CAR_TYPE类型的字典数据
     */
    private String carType;

    /**
     * 核销页面：填写的 车牌号码
     * @see WriteOffUIParamDto#license
     */
    private String carLicense;

    /**
     * 核销页面填写的 车架号
     * @see WriteOffUIParamDto#vinNo
     */
    private String carVinNo;

    /**
     * 服务券发给目标客户的名字
     * @see OrderUserCouponDto#customerName
     */
    private String customerName;

    /**
     * 核销人账号(B端核销)
     */
    private String storeAccountCode;

    /**
     * 核销人（后台手工核销）
     */
    private String adminCode;

    /**
     * 核销人所属发放主体编号
     * （1）如果是 发放主体平台账号登录 核销的，则是该平台账号的发放主体
     *  (2）如果是登录的admin系统账号核销的，则存的是服务用户券的 发放主体编号
     */
    private String writeIssueBodyCode;

    /**
     * 核销时间
     */
    private LocalDateTime writeTime;

    /**
     * 核销时：填写的备注信息
     */
    private String remark;


    /**
     * 核销 上传的附件信息
     */
    @TableField(exist = false)
    private List<EvaluateAttach> attachList;


    //获得核销人
    public String getWriteUser() {
        if(DictWriteOffWay.ADMIN_MANUAL.equals(writeWay)) {
            if(StringUtils.isEmpty(adminCode)) {
                return "系统账号";
            }else {
                return  "系统账号（" + adminCode + "）";
            }
        }

        //B端平台账号
        return "发放主体平台账号("+storeAccountCode+")";
    }


    //以下 方便页面显示
    private transient String carTypeLabel;
    private transient String writeWayLabel;

    //核销人主体名字【主体简称】
    private transient String writeIssueBodyName;

}
