/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.util.ArithUtil;
import java.math.BigDecimal;

public class OrderSettlement
extends IdEntity {
    private static final long serialVersionUID = 1L;
    @UniqueField
    private String orderCode;
    private BigDecimal storeSettlePrice;
    private String storeSettleStatus;
    private BigDecimal enterpriceSettlePrice;
    @Deprecated
    private String enterpriceSettleStatus;
    private String enterpriceCode;
    private transient String enterpriceName;
    private transient String enterpriceSettleStatusLabel;
    private transient String storeSettleStatusLabel;

    public String getFmtStoreSettlePrice() {
        if (this.storeSettlePrice == null) {
            return "";
        }
        return ArithUtil.getNoSymbolCurrency(this.storeSettlePrice.doubleValue());
    }

    @Deprecated
    public String getFmtEnterpriceSettlePrice() {
        if (this.enterpriceSettlePrice == null) {
            return "";
        }
        return ArithUtil.getNoSymbolCurrency(this.enterpriceSettlePrice.doubleValue());
    }

    public OrderSettlement setOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    public OrderSettlement setStoreSettlePrice(BigDecimal storeSettlePrice) {
        this.storeSettlePrice = storeSettlePrice;
        return this;
    }

    public OrderSettlement setStoreSettleStatus(String storeSettleStatus) {
        this.storeSettleStatus = storeSettleStatus;
        return this;
    }

    public OrderSettlement setEnterpriceSettlePrice(BigDecimal enterpriceSettlePrice) {
        this.enterpriceSettlePrice = enterpriceSettlePrice;
        return this;
    }

    @Deprecated
    public OrderSettlement setEnterpriceSettleStatus(String enterpriceSettleStatus) {
        this.enterpriceSettleStatus = enterpriceSettleStatus;
        return this;
    }

    public OrderSettlement setEnterpriceCode(String enterpriceCode) {
        this.enterpriceCode = enterpriceCode;
        return this;
    }

    public OrderSettlement setEnterpriceName(String enterpriceName) {
        this.enterpriceName = enterpriceName;
        return this;
    }

    public OrderSettlement setEnterpriceSettleStatusLabel(String enterpriceSettleStatusLabel) {
        this.enterpriceSettleStatusLabel = enterpriceSettleStatusLabel;
        return this;
    }

    public OrderSettlement setStoreSettleStatusLabel(String storeSettleStatusLabel) {
        this.storeSettleStatusLabel = storeSettleStatusLabel;
        return this;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public BigDecimal getStoreSettlePrice() {
        return this.storeSettlePrice;
    }

    public String getStoreSettleStatus() {
        return this.storeSettleStatus;
    }

    public BigDecimal getEnterpriceSettlePrice() {
        return this.enterpriceSettlePrice;
    }

    @Deprecated
    public String getEnterpriceSettleStatus() {
        return this.enterpriceSettleStatus;
    }

    public String getEnterpriceCode() {
        return this.enterpriceCode;
    }

    public String getEnterpriceName() {
        return this.enterpriceName;
    }

    public String getEnterpriceSettleStatusLabel() {
        return this.enterpriceSettleStatusLabel;
    }

    public String getStoreSettleStatusLabel() {
        return this.storeSettleStatusLabel;
    }
}

