/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.dto.peccancy;

import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrderItem;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class QueryPeccancyConditionsDto
implements Serializable {
    private static final long serialVersionUID = 6026584350411146502L;
    @NonNull
    private String userCode;
    @NonNull
    private String plateNumber;
    @NonNull
    private Integer carProperty;
    @NonNull
    private String frameNumber;
    @NonNull
    private String engineNumber;
    @NonNull
    private String carType;
    private String orderCode;
    private List<String> peccancyIds;

    public static QueryPeccancyConditionsDto valueOfPeccancyOrder(OrderPeccancyOrder peccancyOrder) {
        QueryPeccancyConditionsDto conditionsDto = new QueryPeccancyConditionsDto();
        conditionsDto.setCarProperty(Integer.valueOf(peccancyOrder.getCarProperty()));
        conditionsDto.setUserCode(peccancyOrder.getUserCode());
        conditionsDto.setCarType(peccancyOrder.getCarType());
        conditionsDto.setEngineNumber(peccancyOrder.getEngineNumber());
        conditionsDto.setFrameNumber(peccancyOrder.getFrameNumber());
        conditionsDto.setPlateNumber(peccancyOrder.getPlateNumber());
        conditionsDto.setOrderCode(peccancyOrder.getOrderCode());
        List<String> peccancyIdList = peccancyOrder.getItemList().stream().map(OrderPeccancyOrderItem::getPeccancyId).collect(Collectors.toList());
        conditionsDto.setPeccancyIds(peccancyIdList);
        return conditionsDto;
    }

    @NonNull
    public String getUserCode() {
        return this.userCode;
    }

    @NonNull
    public String getPlateNumber() {
        return this.plateNumber;
    }

    @NonNull
    public Integer getCarProperty() {
        return this.carProperty;
    }

    @NonNull
    public String getFrameNumber() {
        return this.frameNumber;
    }

    @NonNull
    public String getEngineNumber() {
        return this.engineNumber;
    }

    @NonNull
    public String getCarType() {
        return this.carType;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public List<String> getPeccancyIds() {
        return this.peccancyIds;
    }

    public void setUserCode(@NonNull String userCode) {
        if (userCode == null) {
            throw new NullPointerException("userCode is marked non-null but is null");
        }
        this.userCode = userCode;
    }

    public void setPlateNumber(@NonNull String plateNumber) {
        if (plateNumber == null) {
            throw new NullPointerException("plateNumber is marked non-null but is null");
        }
        this.plateNumber = plateNumber;
    }

    public void setCarProperty(@NonNull Integer carProperty) {
        if (carProperty == null) {
            throw new NullPointerException("carProperty is marked non-null but is null");
        }
        this.carProperty = carProperty;
    }

    public void setFrameNumber(@NonNull String frameNumber) {
        if (frameNumber == null) {
            throw new NullPointerException("frameNumber is marked non-null but is null");
        }
        this.frameNumber = frameNumber;
    }

    public void setEngineNumber(@NonNull String engineNumber) {
        if (engineNumber == null) {
            throw new NullPointerException("engineNumber is marked non-null but is null");
        }
        this.engineNumber = engineNumber;
    }

    public void setCarType(@NonNull String carType) {
        if (carType == null) {
            throw new NullPointerException("carType is marked non-null but is null");
        }
        this.carType = carType;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setPeccancyIds(List<String> peccancyIds) {
        this.peccancyIds = peccancyIds;
    }
}

