/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.entity.trace;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.util.TraceUtils;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseTrace
extends IdEntity {
    private String coreCode;
    @TableField(value="buss_params")
    private String bussParamJson;
    private String respMsg;
    private String respCode;
    private Long spendMillis;
    private LocalDateTime callStartTime;
    private LocalDateTime createTime;
    private String description;
    @JsonIgnore
    private transient Map<String, Object> bussParamMap;

    public String getSpendTime() {
        return TraceUtils.prettyMillis(this.spendMillis);
    }

    public BaseTrace putBussParam(String key, Object value) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            if (this.bussParamMap == null) {
                this.bussParamMap = Maps.newLinkedHashMap();
            }
            this.bussParamMap.put(key, value);
        }
        return this;
    }

    public BaseTrace setCoreCode(String coreCode) {
        this.coreCode = coreCode;
        return this;
    }

    public BaseTrace setBussParamJson(String bussParamJson) {
        this.bussParamJson = bussParamJson;
        return this;
    }

    public BaseTrace setRespMsg(String respMsg) {
        this.respMsg = respMsg;
        return this;
    }

    public BaseTrace setRespCode(String respCode) {
        this.respCode = respCode;
        return this;
    }

    public BaseTrace setSpendMillis(Long spendMillis) {
        this.spendMillis = spendMillis;
        return this;
    }

    public BaseTrace setCallStartTime(LocalDateTime callStartTime) {
        this.callStartTime = callStartTime;
        return this;
    }

    public BaseTrace setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public BaseTrace setDescription(String description) {
        this.description = description;
        return this;
    }

    public BaseTrace setBussParamMap(Map<String, Object> bussParamMap) {
        this.bussParamMap = bussParamMap;
        return this;
    }

    public String getCoreCode() {
        return this.coreCode;
    }

    public String getBussParamJson() {
        return this.bussParamJson;
    }

    public String getRespMsg() {
        return this.respMsg;
    }

    public String getRespCode() {
        return this.respCode;
    }

    public Long getSpendMillis() {
        return this.spendMillis;
    }

    public LocalDateTime getCallStartTime() {
        return this.callStartTime;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getBussParamMap() {
        return this.bussParamMap;
    }
}

