/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressUtil {
    private static final Logger log = LoggerFactory.getLogger(IpAddressUtil.class);
    public static String START_IP_ADDRESS = "127.0.0.1";

    private IpAddressUtil() {
    }

    public static String getRealIpNow() {
        Enumeration<NetworkInterface> netInterfaces;
        String localIp = null;
        String netIp = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6ip\u5730\u5740\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return START_IP_ADDRESS;
        }
        boolean isFind = false;
        block2: while (netInterfaces.hasMoreElements() && !isFind) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                    netIp = ip.getHostAddress();
                    isFind = true;
                    continue block2;
                }
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                localIp = ip.getHostAddress();
            }
        }
        if (netIp != null && !"".equals(netIp)) {
            return netIp;
        }
        return localIp;
    }

    static {
        START_IP_ADDRESS = IpAddressUtil.getRealIpNow();
    }
}

