/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.dto.trace.TraceDto;
import com.rocogz.syy.order.util.ArithUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;

public final class TraceUtils {
    static final String RESPONSE_NULL = "\u8fd4\u56deResponse\u5bf9\u8c61\u4e3aNULL";

    private TraceUtils() {
    }

    public static String getErrorMessage(Response resp, Throwable ex) {
        if (ex != null) {
            return ex.getMessage();
        }
        return TraceUtils.getRespErrorMsg(resp);
    }

    public static TraceDto getTraceDto(Response resp, Throwable ex) {
        TraceDto traceDto = new TraceDto();
        if (resp == null) {
            traceDto.setRespMsg(RESPONSE_NULL);
        } else {
            traceDto.setRespCode(resp.getCode());
            traceDto.setRespMsg(resp.getMessage());
        }
        TraceDto errorTraceDto = TraceUtils.getTraceDto(ex);
        BeanUtils.copyProperties((Object)errorTraceDto, (Object)traceDto);
        return traceDto;
    }

    public static TraceDto getTraceDto(LocalDateTime callStartTime, Response resp, Throwable ex) {
        TraceDto traceDto = TraceUtils.getTraceDto(resp, ex);
        traceDto.setStartTimeAndCalcSpend(callStartTime);
        return traceDto;
    }

    public static TraceDto getTraceDto(Throwable ex) {
        if (ex == null) {
            return TraceDto.EMPTY_TRACE_DTO;
        }
        StackTraceElement targetStack = null;
        StackTraceElement[] traceElems = Thread.currentThread().getStackTrace();
        for (int i = 1; i < traceElems.length; ++i) {
            if (TraceUtils.class.getName().equals(traceElems[i].getClassName())) continue;
            targetStack = traceElems[i];
            break;
        }
        TraceDto traceDto = new TraceDto();
        if (targetStack != null) {
            traceDto.setErrorLine(targetStack.getLineNumber());
            traceDto.setErrorMethod(targetStack.getMethodName());
            traceDto.setErrorClassName(targetStack.getClassName());
        }
        traceDto.setStackTrace(TraceUtils.getStackTrace(ex));
        return traceDto;
    }

    public static TraceDto getTraceDto(LocalDateTime callStartTime, Throwable ex) {
        if (ex == null) {
            TraceDto traceDto = new TraceDto();
            traceDto.setStartTimeAndCalcSpend(callStartTime);
            return traceDto;
        }
        TraceDto traceDto = TraceUtils.getTraceDto(ex);
        traceDto.setStartTimeAndCalcSpend(callStartTime);
        return traceDto;
    }

    public static String getErrorTrace(Response resp, Throwable ex) {
        if (ex != null) {
            return TraceUtils.getStackTrace(ex);
        }
        return TraceUtils.getRespErrorMsg(resp);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static String getRespErrorMsg(Response resp) {
        if (resp == null) {
            return RESPONSE_NULL;
        }
        if (!resp.isSucceed()) {
            return resp.getMessage();
        }
        return null;
    }

    public static final String prettyMillis(long millisSeconds) {
        int divided = 1000;
        if (millisSeconds < 1000L) {
            return millisSeconds + "\u6beb\u79d2";
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millisSeconds);
        long mod = millisSeconds % 1000L;
        if (mod != 0L) {
            double result = (double)seconds + (double)mod * 1.0 / 1000.0;
            return ArithUtil.round(result, 2) + "\u79d2";
        }
        return seconds + "\u79d2";
    }
}

