package com.rocogz.syy.operation.dto.quotapply;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.*;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * admin端搜索 额度申请单 查询参数
 *
 * @author zhangmin
 */
@Setter
@Getter
public class AdminSearchQuotaApplyParamDto extends BaseSearchQuotaApplyDto {

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;

    /**
     * 数据范围，如果是管理员账号,数据范围是ALL, 其它账号数据范围是 RELATE_ME
     */
//    private QuotaApplyQueryDataRangeEnum dataRange = QuotaApplyQueryDataRangeEnum.ALL;
//
//    private QuotaApplyQueryTaskTypeEnum taskType = QuotaApplyQueryTaskTypeEnum.ABOUT_ME;

    /**
     * admin端登录的用户名,可能是申请人或审批人的用户名
     */
    private String loginUserName;


    /**
     * 申请单号：【精确匹配】
     */
    private String applyCode;


    /**
     * 申请人名字:[模糊匹配]
     */
    private String applierName;

    /**
     * 申请人手机:[要模糊匹配]
     */
    private String applierMobile;


    /**
     * 申请模式
     */
    private QuotaApplyModeEnum applyMode;

    /**
     * 额度管理模式
     */
    private QuotaManageModeEnum quotaManageMode;

    /**
     * 备付金模式下：充值类型
     */
    private CoverDepositTypeEnum depositType;

    /***
     * 申请端入口
     * @see OperationConstant.DictQuotaApplyPortal#B_WEAPP
     */
    private String portal;

    /**
     * 申请开始日期
     */
    private String startDate;

    /**
     * 申请结束日期
     */
    private String endDate;


    /**
     * 划拨开始日期
     */
    private String allocateStartDate;

    /**
     * 划拨结束日期
     */
    private String allocateEndDate;


    @JsonIgnore
    public String getLikeApplierName() {
        if (StringUtils.isBlank(applierName)) {
            return null;
        }
        return "%" + applierName + "%";
    }

    @JsonIgnore
    public String getLikeApplierMobile(){
        if (StringUtils.isBlank(applierMobile)) {
            return null;
        }
        return "%" + applierMobile + "%";
    }


    public String getStartDate() {
        if (StringUtils.isBlank(startDate)) {
            return null;
        }

        return startDate + OperationConstant.MIN_TIME_SUFFIX;
    }


    public String getEndDate() {
        if (StringUtils.isBlank(endDate)) {
            return null;
        }

        return endDate + OperationConstant.MAX_TIME_SUFFIX;
    }


    public String getAllocateStartDate() {
        if (StringUtils.isBlank(allocateStartDate)) {
            return null;
        }

        return allocateStartDate + OperationConstant.MIN_TIME_SUFFIX;
    }


    public String getAllocateEndDate() {
        if (StringUtils.isBlank(allocateEndDate)) {
            return null;
        }

        return allocateEndDate + OperationConstant.MAX_TIME_SUFFIX;
    }


}
