package com.rocogz.syy.operation.entity.quotapply;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.QuotaApplyActionTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 额度审批流审批进度
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateQuotaApplyProgress extends IdEntity {

    /**
     * 申请单编码
     */
    private String applyCode;

    /**
     * 操作名称：例如：提交申请,一级审计员审核
     */
    private String actionName;

    /**
     * 操作类型：例如 提交申请，审批，审核，作废
     *
     * @see QuotaApplyActionTypeEnum
     */
    private String actionType;

    /**
     * 操作结果, 通过或不通过
     *
     * @see OperationConstant.DictApproveResult
     */
    private String actionResult;

    /**
     * 流程节点编号
     */
    private String nodeCode;

    /**
     * 操作批注
     */
    private String remark;

    /**
     * 操作人类型：申请人、操作人、撤回人
     */
    private String userType;

    /**
     * 操作人用户名
     */
    private String userName;

    /**
     * 操作人手机号
     */
    private String userMobile;

    /**
     * 操作人姓名
     */
    private String userFullName;

    /**
     * 操作是否发生
     */
    private Boolean happened;

    /**
     * 操作时间
     */
    private LocalDateTime actionTime;

    /**
     * 该审批节点 包括的附件数量
     */
    private Integer attachNum;

    /**
     * 审批记录Id
     */
    private Integer approveRecordId;


    /**
     * 划拨操作,备付金帐户充值交易业务单据号
     */
    private transient String coverAcctTradeNo;

}
